/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import javax.swing.SwingUtilities;
import poseViewer.CurrentPose;
import poseViewer.PoseContainer2;
import poseViewer.PoseView;

public class AnimationThread
extends Thread {
    private PoseView poseView;
    private float speedX;
    private float speedY;
    private boolean exitFlag;

    public AnimationThread(PoseView pose) {
        this.poseView = pose;
    }

    public AnimationThread(PoseView pose, AnimationState state) {
        this.poseView = pose;
        this.speedX = state.speedX;
        this.speedY = state.speedY;
    }

    @Override
    public void run() {
        while (!this.exitFlag) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.doAnimation();
        }
    }

    private synchronized void doAnimation() {
        if (this.isAnimated()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CurrentPose pose = AnimationThread.this.poseView.getCurrentPose();
                    PoseContainer2 poses = pose.getPoses();
                    float angX = pose.getCurAngX();
                    float angY = pose.getCurAngY();
                    angX += AnimationThread.this.speedX;
                    angY += AnimationThread.this.speedY;
                    if (!poses.fullRotateX(pose.getCurPose())) {
                        if (angX > poses.getRotXEndAngle()) {
                            angX = poses.getRotXEndAngle();
                            AnimationThread.this.speedX = -AnimationThread.this.speedX;
                        }
                        if (angX < poses.getRotXStartAngle()) {
                            angX = poses.getRotXStartAngle();
                            AnimationThread.this.speedX = -AnimationThread.this.speedX;
                        }
                    }
                    if (!poses.fullRotateY(pose.getCurPose())) {
                        if (angY > poses.getRotYEndAngle()) {
                            angY = poses.getRotYEndAngle();
                            AnimationThread.this.speedY = -AnimationThread.this.speedY;
                        }
                        if (angY < poses.getRotYStartAngle()) {
                            angY = poses.getRotYStartAngle();
                            AnimationThread.this.speedY = -AnimationThread.this.speedY;
                        }
                    }
                    pose.setCurAngX(angX);
                    pose.setCurAngY(angY);
                    AnimationThread.this.poseView.fastRepaint();
                }
            });
        }
    }

    @Override
    public synchronized void start() {
        this.exitFlag = false;
        super.start();
    }

    public synchronized void halt() throws InterruptedException {
        this.exitFlag = true;
        this.join();
    }

    public synchronized void haltNoWait() {
        this.exitFlag = true;
    }

    public void addSpeed(float f, float g) {
        this.speedX += f;
        this.speedY += g;
    }

    boolean isAnimated() {
        return !((double)Math.abs(this.speedX) < 0.01) || !((double)Math.abs(this.speedY) < 0.01);
    }

    public AnimationState getAnimationState() {
        return new AnimationState(this.speedX, this.speedY);
    }

    public static class AnimationState {
        protected float speedX;
        protected float speedY;

        public AnimationState(float speedX, float speedY) {
            this.speedX = speedX;
            this.speedY = speedY;
        }
    }
}

