/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import poseViewer.ImageLoadNotify;

public class BackgroundLoader
implements Runnable {
    private File currentFile = null;
    private ImageLoadNotify currentNotify = null;
    private File nextFile = null;
    private ImageLoadNotify nextNotify = null;

    public synchronized void registerToLoad(File imagePath, ImageLoadNotify notify) {
        this.nextFile = imagePath;
        this.nextNotify = notify;
        if (this.currentFile == null) {
            this.currentFile = this.nextFile;
            this.currentNotify = this.nextNotify;
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        BufferedImage img = null;
        File lastFile = null;
        while (this.getNext()) {
            if (lastFile != null && this.currentFile.equals(lastFile)) {
                this.currentNotify.loadComplete(img);
                continue;
            }
            try {
                byte[] reserved = new byte[0x500000];
                img = ImageIO.read(this.currentFile);
                this.currentNotify.loadComplete(img);
                lastFile = this.currentFile;
            }
            catch (Throwable e) {
                this.currentNotify.loadError(e);
            }
        }
    }

    private synchronized boolean getNext() {
        this.currentFile = this.nextFile;
        this.currentNotify = this.nextNotify;
        this.nextFile = null;
        this.nextNotify = null;
        return this.currentFile != null && this.currentFile != null;
    }
}

