/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import poseViewer.ImageCache;
import poseViewer.ImageLoadNotify;

public class CachedImage {
    private ImageCache cache;
    private Image image;
    private Image thumbnail;
    File imagePath;

    public CachedImage(ImageCache cache, File imagePath) throws Throwable {
        this.cache = cache;
        this.imagePath = imagePath;
        this.image = null;
        this.createThumbnail(cache.getSugPixels());
    }

    public synchronized void createThumbnail(long pixels) throws Throwable {
        long h;
        Image src = this.loadImage(null);
        long w = src.getWidth(null);
        long pixsz = w * (h = (long)src.getHeight(null));
        if (pixsz < pixels) {
            this.image = src;
            this.thumbnail = src;
        }
        long scaleDown = (int)Math.sqrt(pixsz / pixels) + 1;
        long tw = w / scaleDown;
        long th = h / scaleDown;
        if (tw < 1L) {
            tw = 1L;
        }
        if (th < 1L) {
            th = 1L;
        }
        BufferedImage trg = new BufferedImage((int)tw, (int)th, 4);
        Graphics2D g = trg.createGraphics();
        g.drawImage(src, 0, 0, (int)tw, (int)th, 0, 0, (int)w, (int)h, null);
        this.thumbnail = trg;
    }

    public static long memorySizeToPixels(long totalMemory, int countImages) {
        return totalMemory / (long)(8 * countImages);
    }

    public synchronized void freeImage() {
        this.image = null;
    }

    public synchronized Image getImage(ImageLoadNotify observer) throws Throwable {
        if (observer != null && observer.getThumbOnly()) {
            return this.thumbnail;
        }
        if (this.image == null) {
            Image img = this.loadImage(observer);
            if (img != this.thumbnail) {
                this.image = img;
                this.cache.setAccessed(this);
            }
            return img;
        }
        this.cache.setAccessed(this);
        return this.image;
    }

    private Image loadImage(ImageLoadNotify observer) throws Throwable {
        while (true) {
            try {
                Image img = this.createImage(observer);
                return img;
            }
            catch (OutOfMemoryError e) {
                if (this.cache.freeSomeMemory()) continue;
                throw e;
            }
            break;
        }
    }

    Image createImage(ImageLoadNotify observer) throws Throwable {
        if (observer == null) {
            return ImageIO.read(this.imagePath);
        }
        observer.loadStarted();
        this.cache.loadBackground(this.imagePath, new CacheNotify(observer));
        return this.thumbnail;
    }

    public boolean testOutOfMemory(Throwable e) {
        try {
            OutOfMemoryError memerr = (OutOfMemoryError)e;
            return memerr != null;
        }
        catch (ClassCastException x) {
            return false;
        }
    }

    private synchronized void notifyLoadComplete(Image img) {
        this.image = img;
        this.cache.setAccessed(this);
    }

    private class CacheNotify
    implements ImageLoadNotify {
        private ImageLoadNotify nextNotify;

        public CacheNotify(ImageLoadNotify nextNotify) {
            this.nextNotify = nextNotify;
        }

        @Override
        public void loadComplete(Image img) {
            CachedImage.this.notifyLoadComplete(img);
            this.nextNotify.loadComplete(img);
        }

        @Override
        public void loadError(Throwable e) {
            if (CachedImage.this.testOutOfMemory(e)) {
                if (CachedImage.this.cache.freeSomeMemory()) {
                    CachedImage.this.cache.loadBackground(CachedImage.this.imagePath, this);
                    return;
                }
                this.nextNotify.loadError(e);
            } else {
                this.nextNotify.loadError(e);
            }
            CachedImage.this.image = CachedImage.this.thumbnail;
        }

        @Override
        public void loadStarted() {
            this.nextNotify.loadStarted();
        }

        @Override
        public boolean getThumbOnly() {
            return this.nextNotify.getThumbOnly();
        }
    }
}

