/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import poseViewer.AnimationThread;
import poseViewer.CheckBoxActionPropertyListener;
import poseViewer.CurrentPose;
import poseViewer.PoseView;

public class ControlActions {
    private PoseView poseView = null;
    private AnimationThread animation = null;
    private AnimationThread.AnimationState animState = null;
    private Action bPrevPose = new AbstractAction("Prev. Pose", ControlActions.loadIcon("prevPose.png")){
        private static final long serialVersionUID = 5458380448149442840L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ControlActions.this.onPrevPose();
        }
    };
    private Action bNextPose;
    private Action bUp;
    private Action bDown;
    private Action bLeft = new AbstractAction("Turn left", ControlActions.loadIcon("arrowL.png")){
        private static final long serialVersionUID = 7240924168112732980L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ControlActions.this.onToggleCameraLeft();
        }
    };
    private Action bRight;
    private Action bAnimate;
    private Action bReset;
    private Action bZoomIn;
    private Action bZoomOut;
    private Action bPanLeft;
    private Action bPanRight;
    private Action bPanUp;
    private Action bPanDown;
    private Action bPrint;
    private Action bPrintSetup;
    private Action bPageSetup;
    private Action bFit;
    private Action bCopyImage;
    private Action bAnimSetViewMax;
    private Action bAnimSetViewFit;
    private Action bAnimSetViewThumb;
    private Action bZoom1to1;
    private PrinterJob printJob = null;
    private PageFormat pageFormat = null;
    private final float SPEED_STEP = 2.0f;
    public static String KEY_SELECTED = CheckBoxActionPropertyListener.KEY_SELECTED;

    protected void finalize() throws Throwable {
        if (this.animation != null) {
            this.animation.haltNoWait();
        }
        super.finalize();
    }

    static Icon loadIcon(String name) {
        URL resourceUrl = ControlActions.class.getResource("resources/" + name);
        return new ImageIcon(resourceUrl);
    }

    public ControlActions() {
        this.bUp = new AbstractAction("Turn up", ControlActions.loadIcon("arrowU.png")){
            private static final long serialVersionUID = 283898590963757494L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onToggleCameraUp();
            }
        };
        this.bAnimate = new AbstractAction("Play/Stop", ControlActions.loadIcon("animation.png")){
            private static final long serialVersionUID = -8236801840489617774L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onToggleAnimate();
            }
        };
        this.bDown = new AbstractAction("Turn down", ControlActions.loadIcon("arrowD.png")){
            private static final long serialVersionUID = -5750649359922755052L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onToggleCameraDown();
            }
        };
        this.bRight = new AbstractAction("Turn right", ControlActions.loadIcon("arrowR.png")){
            private static final long serialVersionUID = -6690748442620214586L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onToggleCameraRight();
            }
        };
        this.bNextPose = new AbstractAction("Next Pose", ControlActions.loadIcon("nextPose.png")){
            private static final long serialVersionUID = -8828819194652232545L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onNextPose();
            }
        };
        this.bReset = new AbstractAction("Reset", ControlActions.loadIcon("reset.png")){
            private static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onReset();
            }
        };
        this.bFit = new AbstractAction("Fit to window", ControlActions.loadIcon("fitInWin.png")){
            private static final long serialVersionUID = 6311163631712655448L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onFit();
            }
        };
        this.bZoomIn = new AbstractAction("Zoom In", ControlActions.loadIcon("zoom_plus.png")){
            private static final long serialVersionUID = -7518715372379202010L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.poseView.zoomStep(2);
            }
        };
        this.bZoomOut = new AbstractAction("Zoom Out", ControlActions.loadIcon("zoom_minus.png")){
            private static final long serialVersionUID = -2903176815897954645L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.poseView.zoomStep(-2);
            }
        };
        this.bZoom1to1 = new AbstractAction("Original size (1:1)", ControlActions.loadIcon("zoom1to1.png")){
            private static final long serialVersionUID = -2903176815897954649L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.poseView.zoom1to1();
            }
        };
        this.bPanLeft = new AbstractAction("Pan Left", ControlActions.loadIcon("pan_left.png")){
            private static final long serialVersionUID = 7519331717564635174L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.poseView.panStep(-50, 0);
            }
        };
        this.bPanRight = new AbstractAction("Pan Right", ControlActions.loadIcon("pan_right.png")){
            private static final long serialVersionUID = 601674299088438535L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.poseView.panStep(50, 0);
            }
        };
        this.bPanUp = new AbstractAction("Pan Up", ControlActions.loadIcon("pan_up.png")){
            private static final long serialVersionUID = 6695258917696686284L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.poseView.panStep(0, -50);
            }
        };
        this.bPanDown = new AbstractAction("Pan Down", ControlActions.loadIcon("pan_down.png")){
            private static final long serialVersionUID = -6424605170149534962L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.poseView.panStep(0, 50);
            }
        };
        this.bPrint = new AbstractAction("Print", ControlActions.loadIcon("print.png")){
            private static final long serialVersionUID = 785124901336972041L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onPrint();
            }
        };
        this.bPrintSetup = new AbstractAction("Printer Setup ..."){
            private static final long serialVersionUID = 8522947044137589205L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onPrinterSetup();
            }
        };
        this.bPageSetup = new AbstractAction("Page Setup ..."){
            private static final long serialVersionUID = -9093570860600141366L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onPageSetup();
            }
        };
        this.bCopyImage = new AbstractAction("Copy to clipboard", ControlActions.loadIcon("copyicon.png")){
            private static final long serialVersionUID = -1667594732712138858L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onCopyToClipboard();
            }
        };
        this.bAnimSetViewFit = new AbstractAction("Fit to window"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onSetAnimMode(1);
            }
        };
        this.bAnimSetViewMax = new AbstractAction("Keep current pan & zoom"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onSetAnimMode(0);
            }
        };
        this.bAnimSetViewThumb = new AbstractAction("Thumbnail size"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlActions.this.onSetAnimMode(2);
            }
        };
        this.bLeft.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 0, false));
        this.bRight.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 0, false));
        this.bUp.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 0, false));
        this.bDown.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 0, false));
        this.bNextPose.putValue("AcceleratorKey", KeyStroke.getKeyStroke(34, 0, false));
        this.bPrevPose.putValue("AcceleratorKey", KeyStroke.getKeyStroke(33, 0, false));
        this.bFit.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        this.bReset.putValue("AcceleratorKey", KeyStroke.getKeyStroke(155, 0, false));
        int shift = 1;
        int ctrl = 2;
        this.bPanLeft.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, shift, false));
        this.bPanRight.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, shift, false));
        this.bPanUp.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, shift, false));
        this.bPanDown.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, shift, false));
        this.bZoomIn.putValue("AcceleratorKey", KeyStroke.getKeyStroke(107, 0, false));
        this.bZoomOut.putValue("AcceleratorKey", KeyStroke.getKeyStroke(109, 0, false));
        this.bPrint.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, ctrl, false));
        this.bCopyImage.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, ctrl, false));
        this.bAnimate.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
        this.updateButtonState();
    }

    protected void onSetAnimMode(int thumbType) {
        this.poseView.setThumbType(thumbType);
        this.updateThumbTypeActions();
    }

    private void updateThumbTypeActions() {
        if (this.poseView != null) {
            int curMode = this.poseView.getThumbType();
            this.bAnimSetViewFit.putValue(KEY_SELECTED, new Boolean(curMode == 1));
            this.bAnimSetViewMax.putValue(KEY_SELECTED, new Boolean(curMode == 0));
            this.bAnimSetViewThumb.putValue(KEY_SELECTED, new Boolean(curMode == 2));
        }
    }

    private void updateButtonState() {
        boolean enabled;
        boolean animateEnabled = enabled = this.poseView != null;
        if (enabled) {
            CurrentPose currentPose = this.poseView.getCurrentPose();
            int curPose = currentPose.getCurPose();
            animateEnabled = currentPose.getPoses().fullRotateX(curPose) || currentPose.getPoses().fullRotateY(curPose);
        }
        this.bPrevPose.setEnabled(enabled);
        this.bNextPose.setEnabled(enabled);
        this.bUp.setEnabled(enabled);
        this.bDown.setEnabled(enabled);
        this.bLeft.setEnabled(enabled);
        this.bRight.setEnabled(enabled);
        this.bAnimate.setEnabled(animateEnabled);
        this.bReset.setEnabled(enabled);
        this.bFit.setEnabled(enabled);
        this.bZoomIn.setEnabled(enabled);
        this.bZoomOut.setEnabled(enabled);
        this.bPanLeft.setEnabled(enabled);
        this.bPanRight.setEnabled(enabled);
        this.bPanUp.setEnabled(enabled);
        this.bPanDown.setEnabled(enabled);
        this.bPrint.setEnabled(enabled);
        this.bCopyImage.setEnabled(enabled);
        this.bZoom1to1.setEnabled(enabled);
        this.updateThumbTypeActions();
    }

    protected void onToggleCameraUp() {
        CurrentPose curPose = this.poseView.getCurrentPose();
        int curPose2 = curPose.getCurPose();
        if (this.isAnimated() && curPose.getPoses().fullRotateY(curPose2)) {
            this.animation.addSpeed(0.0f, -2.0f);
        } else {
            curPose.setCurAngY(curPose.getCurAngY() - curPose.getPoses().getAngleStepY(curPose2));
            this.poseView.fastRepaint();
        }
    }

    private boolean isAnimated() {
        return this.animation != null;
    }

    protected void onToggleCameraRight() {
        CurrentPose curPose = this.poseView.getCurrentPose();
        int curPose2 = curPose.getCurPose();
        if (this.isAnimated() && curPose.getPoses().fullRotateX(curPose2)) {
            this.animation.addSpeed(2.0f, 0.0f);
        } else {
            curPose.setCurAngX(curPose.getCurAngX() + curPose.getPoses().getAngleStepX(curPose2));
            this.poseView.fastRepaint();
        }
    }

    protected void onToggleCameraDown() {
        CurrentPose curPose = this.poseView.getCurrentPose();
        int curPose2 = curPose.getCurPose();
        if (this.isAnimated() && curPose.getPoses().fullRotateY(curPose2)) {
            this.animation.addSpeed(0.0f, 2.0f);
        } else {
            curPose.setCurAngY(curPose.getCurAngY() + curPose.getPoses().getAngleStepY(curPose2));
            this.poseView.fastRepaint();
        }
    }

    protected void onToggleCameraLeft() {
        CurrentPose curPose = this.poseView.getCurrentPose();
        int curPose2 = curPose.getCurPose();
        if (this.isAnimated() && curPose.getPoses().fullRotateX(curPose2)) {
            this.animation.addSpeed(-2.0f, 0.0f);
        } else {
            curPose.setCurAngX(curPose.getCurAngX() - curPose.getPoses().getAngleStepX(curPose2));
            this.poseView.fastRepaint();
        }
    }

    private void startAnimation() {
        if (this.animation == null) {
            this.animation = this.animState != null ? new AnimationThread(this.poseView, this.animState) : new AnimationThread(this.poseView);
            this.animation.start();
            this.poseView.setThumbOnly(true);
            if (!this.animation.isAnimated()) {
                CurrentPose currentPose = this.poseView.getCurrentPose();
                if (currentPose.getPoses().fullRotateY(currentPose.getCurPose())) {
                    this.onToggleCameraDown();
                    this.onToggleCameraDown();
                    this.onToggleCameraDown();
                } else {
                    this.onToggleCameraRight();
                    this.onToggleCameraRight();
                    this.onToggleCameraRight();
                }
            }
        }
        this.bAnimate.putValue(KEY_SELECTED, Boolean.TRUE);
    }

    void stopAnimation() {
        if (this.animation != null) {
            try {
                this.animation.halt();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            this.animState = this.animation.getAnimationState();
            this.animation = null;
            this.poseView.setThumbOnly(false);
            this.poseView.fastRepaint();
        }
        this.bAnimate.putValue(KEY_SELECTED, Boolean.FALSE);
    }

    protected void onToggleAnimate() {
        Boolean state = (Boolean)this.bAnimate.getValue(KEY_SELECTED);
        if (state.booleanValue()) {
            this.startAnimation();
        } else {
            this.stopAnimation();
        }
    }

    protected void onNextPose() {
        CurrentPose curPose = this.poseView.getCurrentPose();
        curPose.setCurPose(curPose.getCurPose() + 1);
        this.poseView.fastRepaint();
    }

    protected void onPrevPose() {
        CurrentPose curPose = this.poseView.getCurrentPose();
        curPose.setCurPose(curPose.getCurPose() - 1);
        this.poseView.fastRepaint();
    }

    public void attachView(PoseView curView) {
        this.stopAnimation();
        this.poseView = curView;
        this.updateButtonState();
    }

    protected void onFit() {
        this.poseView.fitToView();
    }

    protected void onReset() {
        this.stopAnimation();
        CurrentPose curPose = this.poseView.getCurrentPose();
        if (curPose.getCurAngX() == 0.0f && curPose.getCurAngY() == 0.0f) {
            curPose.setCurPose(0);
        } else {
            curPose.setCurAngX(0.0f);
            curPose.setCurAngY(0.0f);
        }
        this.poseView.fastRepaint();
    }

    public PoseView getPoseView() {
        return this.poseView;
    }

    public Action getBPrevPose() {
        return this.bPrevPose;
    }

    public Action getBNextPose() {
        return this.bNextPose;
    }

    public Action getBUp() {
        return this.bUp;
    }

    public Action getBDown() {
        return this.bDown;
    }

    public Action getBLeft() {
        return this.bLeft;
    }

    public Action getBRight() {
        return this.bRight;
    }

    public Action getBAnimate() {
        return this.bAnimate;
    }

    public Action getBReset() {
        return this.bReset;
    }

    public Action getBFit() {
        return this.bFit;
    }

    public Action getBZoomIn() {
        return this.bZoomIn;
    }

    public Action getBZoomOut() {
        return this.bZoomOut;
    }

    public Action getBPanLeft() {
        return this.bPanLeft;
    }

    public Action getBPanRight() {
        return this.bPanRight;
    }

    public Action getBPanUp() {
        return this.bPanUp;
    }

    public Action getBPanDown() {
        return this.bPanDown;
    }

    public Action getBPrint() {
        return this.bPrint;
    }

    public Action getBPrintSetup() {
        return this.bPrintSetup;
    }

    public Action getBPageSetup() {
        return this.bPageSetup;
    }

    public Action getBCopyImage() {
        return this.bCopyImage;
    }

    protected void onPrinterSetup() {
        PrinterJob jb = this.printJob == null ? PrinterJob.getPrinterJob() : this.printJob;
        if (jb.printDialog()) {
            this.printJob = jb;
        }
    }

    protected void onPrint() {
        try {
            if (this.pageFormat == null || this.printJob == null) {
                this.onPageSetup();
            }
            if (this.pageFormat == null || this.printJob == null) {
                return;
            }
            this.poseView.getCurrentPose().getPoses().getCache().flush();
            this.printJob.setPrintable(this.poseView, this.pageFormat);
            try {
                this.printJob.print();
            }
            catch (PrinterException e) {
                JOptionPane.showMessageDialog(this.poseView, "Print unsuccessful: " + e.getLocalizedMessage());
            }
            this.printJob.setPrintable(null);
        }
        catch (OutOfMemoryError e) {
            if (this.poseView.getCurrentPose().getPoses().getCache().freeSomeMemory()) {
                this.onPrint();
            }
            JOptionPane.showMessageDialog(this.poseView, "Out of memory. Cannot print");
        }
    }

    protected void onPageSetup() {
        PageFormat npf;
        if (this.printJob == null) {
            this.onPrinterSetup();
        }
        if (this.printJob == null) {
            return;
        }
        PageFormat pf = this.pageFormat == null ? this.printJob.defaultPage() : this.pageFormat;
        if (pf != (npf = this.printJob.pageDialog(pf))) {
            this.pageFormat = npf;
        }
    }

    protected void onCopyToClipboard() {
        this.poseView.toClipboard();
    }

    public Action getBAnimSetViewMax() {
        return this.bAnimSetViewMax;
    }

    public Action getBAnimSetViewFit() {
        return this.bAnimSetViewFit;
    }

    public Action getBAnimSetViewThumb() {
        return this.bAnimSetViewThumb;
    }

    public Action getZoom1to1() {
        return this.bZoom1to1;
    }
}

