/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.awt.Dimension;
import java.awt.Image;
import poseViewer.ImageLoadNotify;
import poseViewer.PoseContainer2;

public class CurrentPose {
    PoseContainer2 poses;
    float curAngX = 0.0f;
    float curAngY = 0.0f;
    int curPose = 0;

    public CurrentPose(PoseContainer2 poses) {
        this.poses = poses;
        this.fitCurPose();
    }

    public void fitCurPose() {
        float max;
        float min;
        if (!this.poses.fullRotateX(this.getCurPose())) {
            min = this.poses.getRotXStartAngle();
            max = this.poses.getRotXEndAngle();
            if (this.curAngX > max) {
                this.curAngX = max;
            }
            if (this.curAngX < min) {
                this.curAngX = min;
            }
        } else {
            this.curAngX = (float)((double)this.curAngX - Math.floor(this.curAngX / 360.0f) * 360.0);
        }
        if (!this.poses.fullRotateY(this.getCurPose())) {
            min = this.poses.getRotYStartAngle();
            max = this.poses.getRotYEndAngle();
            if (this.curAngY > max) {
                this.curAngY = max;
            }
            if (this.curAngY < min) {
                this.curAngY = min;
            }
        } else {
            this.curAngY = (float)((double)this.curAngY - Math.floor(this.curAngY / 360.0f) * 360.0);
        }
        if (this.curPose < 0) {
            this.curPose = 0;
        }
        if (this.curPose >= this.poses.countPoses()) {
            this.curPose = this.poses.countPoses() - 1;
        }
    }

    public float getCurAngX() {
        return this.curAngX;
    }

    public void setCurAngX(float curAngX) {
        this.curAngX = curAngX;
        this.fitCurPose();
    }

    public float getCurAngY() {
        return this.curAngY;
    }

    public void setCurAngY(float curAngY) {
        this.curAngY = curAngY;
        this.fitCurPose();
    }

    public int getCurPose() {
        return this.curPose;
    }

    public void setCurPose(int curPose) {
        if (curPose < 0) {
            curPose = 0;
        }
        if (curPose >= this.poses.countPoses()) {
            curPose = this.poses.countPoses() - 1;
        }
        this.curPose = curPose;
        this.fitCurPose();
    }

    public PoseContainer2 getPoses() {
        return this.poses;
    }

    public Image getImage(ImageLoadNotify ntf) throws Throwable {
        return this.poses.getImageA(this.getCurPose(), this.getCurAngX(), this.getCurAngY(), ntf);
    }

    public Dimension getImageSize(ImageLoadNotify ntf) {
        Image img;
        try {
            img = this.getImage(ntf);
        }
        catch (Throwable e) {
            return new Dimension(1, 1);
        }
        Dimension imgDim = new Dimension(img.getWidth(null), img.getHeight(null));
        if (imgDim.width == -1 || imgDim.height == -1) {
            imgDim.width = 1;
            imgDim.height = 1;
        }
        return imgDim;
    }
}

