/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import poseViewer.URLLabel;

public class HelpWindow
extends JDialog {
    private static final long serialVersionUID = 3784196782407969298L;

    public static String loadFile(String filename) {
        String txt = "";
        try {
            InputStream is = HelpWindow.class.getResourceAsStream(filename);
            InputStreamReader rd = new InputStreamReader(is, "UTF-8");
            char[] buff = new char[1024];
            while (rd.read(buff) > 0) {
                txt = String.valueOf(txt) + new String(buff);
            }
        }
        catch (Exception e) {
            txt = String.valueOf(txt) + "\r\n\r\nError: " + e.getLocalizedMessage();
        }
        return txt;
    }

    public HelpWindow(Frame arg0) {
        super(arg0, "Quick Help");
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(jEditorPane);
        HTMLEditorKit kit = new HTMLEditorKit();
        jEditorPane.setEditorKit(kit);
        HTMLDocument doc = (HTMLDocument)kit.createDefaultDocument();
        URL resource = HelpWindow.class.getResource("resources/help/help.html");
        doc.setBase(resource);
        String txt = HelpWindow.loadFile("resources/help/help.html");
        jEditorPane.setDocument(doc);
        jEditorPane.setText(txt);
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent ev) {
                if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpWindow.this.onActivateLink(ev.getURL());
                }
            }
        });
        this.getContentPane().add((Component)scrollPane, "Center");
        this.setSize(new Dimension(700, 700));
        jEditorPane.select(0, 0);
    }

    protected void onActivateLink(URL url) {
        URLLabel.showInBrowser(url.toString(), (JFrame)this.getParent());
    }

    protected void onActivateLink(int pos, JEditorPane editor) {
    }
}

