/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.io.File;
import java.util.LinkedList;
import java.util.ListIterator;
import poseViewer.BackgroundLoader;
import poseViewer.CachedImage;
import poseViewer.ImageLoadNotify;

public class ImageCache {
    private LinkedList cache = new LinkedList();
    private int hintMaxPictures;
    private long totalMemory;
    private BackgroundLoader loader = null;

    public ImageCache(int hintMaxPictures, long totalMemory) {
        this.hintMaxPictures = hintMaxPictures;
        this.totalMemory = totalMemory;
    }

    public synchronized boolean freeSomeMemory() {
        if (this.cache.isEmpty()) {
            return false;
        }
        CachedImage img = (CachedImage)this.cache.getLast();
        this.cache.removeLast();
        img.freeImage();
        return true;
    }

    public synchronized void registerItem(CachedImage cachedImage) {
        this.cache.addFirst(cachedImage);
    }

    public synchronized void setAccessed(CachedImage cachedImage) {
        ListIterator it = (ListIterator)this.cache.iterator();
        while (it.hasNext()) {
            CachedImage img = (CachedImage)it.next();
            if (img != cachedImage) continue;
            it.remove();
            break;
        }
        this.registerItem(cachedImage);
    }

    public long getSugPixels() {
        return CachedImage.memorySizeToPixels(this.totalMemory, this.hintMaxPictures);
    }

    public synchronized void loadBackground(File imagePath, ImageLoadNotify notify) {
        if (this.loader == null) {
            this.loader = new BackgroundLoader();
        }
        this.loader.registerToLoad(imagePath, notify);
    }

    public synchronized long getCount() {
        return this.cache.size();
    }

    public void flush() {
        while (this.freeSomeMemory()) {
        }
    }
}

