/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class ImagePanZoom {
    public float centerX = 0.5f;
    public float centerY = 0.5f;
    public float zoom = 0.0f;
    public int refSize = 0;

    public void setScale(float x) {
        this.zoom = (float)Math.log(x);
    }

    public void setScale(float x, int refSize) {
        this.setScale(x);
        this.refSize = refSize;
    }

    public float getScale() {
        return (float)Math.exp(this.zoom);
    }

    public float getScale(int refSize) {
        return this.getScale() * (float)this.refSize / (float)refSize;
    }

    public float getCenterX() {
        return this.centerX;
    }

    public void setCenterX(float centerX) {
        this.centerX = centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public void setCenterY(float centerY) {
        this.centerY = centerY;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public static int getDominantImgSize(Dimension imgSz, Dimension viewSz) {
        float imgRadix = (float)imgSz.width / (float)imgSz.height;
        float viewRadix = (float)viewSz.width / (float)viewSz.height;
        if (imgRadix > viewRadix) {
            return imgSz.width;
        }
        return imgSz.height;
    }

    public static int getDominantViewSize(Dimension imgSz, Dimension viewSz) {
        float imgRadix = (float)imgSz.width / (float)imgSz.height;
        float viewRadix = (float)viewSz.width / (float)viewSz.height;
        if (imgRadix > viewRadix) {
            return viewSz.width;
        }
        return viewSz.height;
    }

    public TwoRects calcRects(Dimension src, Dimension trg) {
        int rm;
        if (this.refSize == 0) {
            this.fitToView(src, trg);
        }
        int domSize = ImagePanZoom.getDominantImgSize(src, trg);
        float scale = this.getScale(domSize);
        Point viewCenter = new Point(trg.width / 2, trg.height / 2);
        Dimension modfDim = new Dimension(Math.round((float)src.width * scale), Math.round((float)src.height * scale));
        Point leftTop = new Point(viewCenter.x - Math.round((float)modfDim.width * this.getCenterX()), viewCenter.y - Math.round((float)modfDim.height * this.getCenterY()));
        Rectangle trgrc = new Rectangle(leftTop, modfDim);
        int srcleft = 0;
        int srctop = 0;
        int srcright = src.width;
        int srcbottom = src.height;
        if (trgrc.x < 0) {
            rm = (int)Math.floor((float)(-trgrc.x) / scale);
            srcleft += rm;
            trgrc.x += (int)((float)rm * scale);
            trgrc.width -= (int)((float)rm * scale);
        }
        if (trgrc.y < 0) {
            rm = (int)Math.floor((float)(-trgrc.y) / scale);
            srctop += rm;
            trgrc.y += (int)((float)rm * scale);
            trgrc.height -= (int)((float)rm * scale);
        }
        if (trgrc.width > trg.width) {
            rm = (int)Math.floor((float)(trgrc.width - trg.width) / scale) - 1;
            srcright -= rm;
            trgrc.width -= (int)((float)rm * scale);
        }
        if (trgrc.height > trg.height) {
            rm = (int)Math.floor((float)(trgrc.height - trg.height) / scale) - 1;
            srcbottom -= rm;
            trgrc.height -= (int)((float)rm * scale);
        }
        return new TwoRects(new Rectangle(srcleft, srctop, srcright - srcleft, srcbottom - srctop), trgrc);
    }

    void fitToView(Dimension imgSz, Dimension viewSz) {
        this.centerX = 0.5f;
        this.centerY = 0.5f;
        int imgSize = ImagePanZoom.getDominantImgSize(imgSz, viewSz);
        int viewSize = ImagePanZoom.getDominantViewSize(imgSz, viewSz);
        this.setScale((float)viewSize / (float)imgSize, imgSize);
    }

    public Point2D.Float mapMove(Point relativeMove, Dimension imageSize, Dimension viewSize) {
        float scale = this.getScale(ImagePanZoom.getDominantImgSize(imageSize, viewSize));
        return new Point2D.Float((float)relativeMove.x / (float)imageSize.width / scale, (float)relativeMove.y / (float)imageSize.height / scale);
    }

    public static class TwoRects {
        public Rectangle source;
        public Rectangle target;

        public TwoRects(Rectangle source, Rectangle target) {
            this.source = source;
            this.target = target;
        }
    }
}

