/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import poseViewer.AboutDlg;
import poseViewer.CheckBoxActionPropertyListener;
import poseViewer.ControlActions;
import poseViewer.ControlPane;
import poseViewer.CurrentPose;
import poseViewer.ExceptionHandler;
import poseViewer.FileDrop;
import poseViewer.HelpWindow;
import poseViewer.ImageCache;
import poseViewer.PoseLoader;
import poseViewer.PoseView;
import poseViewer.ProgressDlg;
import poseViewer.QuickTipsDlg;
import poseViewer.URLLabel;

public class MainFrame
extends JFrame
implements ExceptionHandler {
    private static final long serialVersionUID = -7608669584258619898L;
    private PoseView curView = null;
    private Container workArea = null;
    private ControlPane control = null;
    private ControlActions actions = new ControlActions();
    private File currentDir = null;
    private ProgressDlg progressBar = null;
    private boolean errorShown = false;
    private JList memoryInfo;
    private HelpWindow helpWindow = null;
    private QuickTipsDlg quickTips;

    public MainFrame() throws HeadlessException {
        super("Pose Viewer");
        this.initFramework();
        this.initContentPane(this.getContentPane());
        this.currentDir = new File("dummy").getParentFile();
        new FileDrop(this, new MyFileDrop());
        try {
            this.setIconImage(ImageIO.read(MainFrame.class.getResource("resources/poseViewSm.png")));
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(this, String.valueOf(e.getLocalizedMessage()) + "\r\n");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void initContentPane(Container inner) {
        Container inin = new Container();
        inner.add((Component)inin, "Center");
        inin.setLayout(new BorderLayout(0, 0));
        this.control = new ControlPane(this.actions);
        inin.add((Component)this.control, "South");
        this.workArea = inin;
        inner.setBackground(Color.BLACK);
        inin.setBackground(Color.BLACK);
        this.memoryInfo = this.addMemoryInfo(this.workArea);
        inin.add(this.createUrlPane(), "North");
    }

    private Component createUrlPane() {
        Container x = new Container();
        x.setLayout(new FlowLayout(1, 0, 0));
        x.add(new URLLabel("Female Anatomy for Artist", "http://www.female-anatomy-for-artist.com/", true, this));
        x.add(new URLLabel("Human Anatomy for Artist", "http://www.human-anatomy-for-artist.com/", false, this));
        x.add(new URLLabel("Human and Animal Photo References", "http://www.3d.sk/", false, this));
        x.add(new URLLabel("Environment Photo References", "http://www.environment-textures.com/", false, this));
        x.add(new URLLabel("Free 3D Tutorials", "http://www.free3dtutorials.com/", false, this));
        x.add(new URLLabel("Reference for Comic Artist", "http://www.photo-reference-for-comic-artists.com/", false, this));
        return x;
    }

    private JList addMemoryInfo(Container cmp) {
        JList memoryInfo = new JList(new ListModel(){

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            public Object getElementAt(int index) {
                long memMax = Runtime.getRuntime().maxMemory();
                long thumb = memMax / 2L;
                long maxPix = memMax / 12L;
                long memSz = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                long maxResolX1 = (int)(Math.sqrt(maxPix) * 4.0 / 3.0);
                long maxResolY1 = maxPix / maxResolX1;
                long maxResolX2 = (int)(Math.sqrt(maxPix) * 3.0 / 4.0);
                long maxResolY2 = maxPix / maxResolX2;
                switch (index) {
                    case 0: {
                        return "Total memory:  " + Long.toString(memMax / 0x100000L) + " MB";
                    }
                    case 1: {
                        return "Thumbnail memory:  " + Long.toString(thumb / 0x100000L) + " MB";
                    }
                    case 2: {
                        return "Max image size: " + Float.toString((float)Math.round((float)maxPix / 100000.0f) / 10.0f) + " Mpx";
                    }
                    case 3: {
                        return " ~ resolution: " + Long.toString(maxResolX1) + " x " + Long.toString(maxResolY1) + ",   " + Long.toString(maxResolX2) + " x " + Long.toString(maxResolY2);
                    }
                    case 4: {
                        return "---------------------------------------------------";
                    }
                    case 5: {
                        return "Used Memory:  " + Long.toString(memSz / 0x100000L) + " MB";
                    }
                    case 6: {
                        if (MainFrame.this.curView != null && MainFrame.this.curView.getCurrentPose() != null && MainFrame.this.curView.getCurrentPose().getPoses() != null && MainFrame.this.curView.getCurrentPose().getPoses().getCache() != null) {
                            ImageCache cache = MainFrame.this.curView.getCurrentPose().getPoses().getCache();
                            return "Cached images:  " + Long.toString(cache.getCount()) + " images";
                        }
                        return "";
                    }
                    case 7: {
                        if (MainFrame.this.curView != null && MainFrame.this.curView.getCurrentPose() != null && MainFrame.this.curView.getCurrentPose().getPoses() != null) {
                            return "Thumbnails image:  " + Long.toString(MainFrame.this.curView.getCurrentPose().getPoses().size()) + " images";
                        }
                        return "";
                    }
                }
                return "";
            }

            @Override
            public int getSize() {
                return 8;
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
        memoryInfo.setBackground(Color.BLACK);
        memoryInfo.setForeground(Color.WHITE);
        memoryInfo.setSelectionBackground(Color.BLACK);
        memoryInfo.setSelectionForeground(Color.WHITE);
        cmp.add(memoryInfo, "Center");
        return memoryInfo;
    }

    private void initFramework() {
        this.setDefaultCloseOperation(3);
        JMenuBar mb = new JMenuBar();
        JMenu mFile = new JMenu("File");
        AbstractAction a = new AbstractAction("Open", ControlActions.loadIcon("open.png")){
            private static final long serialVersionUID = -8531836081987198187L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onFileOpen();
            }
        };
        mFile.add(a);
        a.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        mFile.addSeparator();
        mFile.add(this.actions.getBPrint());
        mFile.add(this.actions.getBPageSetup());
        mFile.add(this.actions.getBPrintSetup());
        mFile.addSeparator();
        a = new AbstractAction("Exit"){
            private static final long serialVersionUID = -2109448359855538968L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
        mFile.add(a);
        a.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        mb.add(mFile);
        JMenu mNav = new JMenu("Camera");
        mNav.add(this.actions.getBReset());
        mNav.addSeparator();
        mNav.add(this.actions.getBPrevPose());
        mNav.add(this.actions.getBNextPose());
        mNav.addSeparator();
        mNav.add(this.actions.getBLeft());
        mNav.add(this.actions.getBRight());
        mNav.addSeparator();
        mNav.add(this.actions.getBUp());
        mNav.add(this.actions.getBDown());
        mNav.addSeparator();
        mNav.add(new MyCheckBoxMenuItem(this.actions.getBAnimate()));
        JMenu mAnimView = new JMenu("Animation size");
        mAnimView.add(new MyCheckBoxMenuItem(this.actions.getBAnimSetViewThumb()));
        mAnimView.add(new MyCheckBoxMenuItem(this.actions.getBAnimSetViewFit()));
        mAnimView.add(new MyCheckBoxMenuItem(this.actions.getBAnimSetViewMax()));
        mNav.add(mAnimView);
        mb.add(mNav);
        JMenu mView = new JMenu("View");
        mView.add(this.actions.getBZoomIn());
        mView.add(this.actions.getBZoomOut());
        mView.add(this.actions.getZoom1to1());
        mView.addSeparator();
        mView.add(this.actions.getBPanLeft());
        mView.add(this.actions.getBPanRight());
        mView.addSeparator();
        mView.add(this.actions.getBPanUp());
        mView.add(this.actions.getBPanDown());
        mView.addSeparator();
        mView.add(this.actions.getBFit());
        mView.addSeparator();
        mView.add(this.actions.getBCopyImage());
        mb.add(mView);
        JMenu mHelp = new JMenu("Help");
        a = new AbstractAction("Controls", ControlActions.loadIcon("help.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainFrame.this.openHelp();
            }
        };
        mHelp.add(a);
        a = new AbstractAction("Quick Tips ..."){
            private static final long serialVersionUID = 3489413974324279911L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onQuickTips();
            }
        };
        mHelp.add(a);
        mHelp.addSeparator();
        a = new AbstractAction("About ..."){
            private static final long serialVersionUID = 3489413974324279911L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onHelpAbout();
            }
        };
        mHelp.add(a);
        a.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
        mHelp.add(new AbstractAction("Memory Information"){
            private static final long serialVersionUID = 4432030490L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onMemoryInfoAction();
            }
        });
        mb.add(mHelp);
        mb.setVisible(true);
        this.setJMenuBar(mb);
        this.setBackground(Color.BLACK);
    }

    public void onQuickTips() {
        if (this.quickTips == null) {
            this.quickTips = new QuickTipsDlg(this);
            this.quickTips.setLocationRelativeTo(this);
        }
        if (!this.quickTips.isVisible()) {
            this.quickTips.setVisible(true);
        }
    }

    protected void openHelp() {
        if (this.helpWindow == null) {
            this.helpWindow = new HelpWindow(this);
            this.helpWindow.setLocationRelativeTo(this);
        }
        if (!this.helpWindow.isVisible()) {
            this.helpWindow.setVisible(true);
        }
    }

    protected void onMemoryInfoAction() {
        JDialog dlg = new JDialog((Frame)this, "Memory infomation");
        this.addMemoryInfo(dlg.getContentPane());
        dlg.setModal(true);
        dlg.setSize(320, 240);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
    }

    protected void onHelpAbout() {
        AboutDlg hlpdlg = new AboutDlg(this);
        hlpdlg.setLocationRelativeTo(this);
        hlpdlg.setModal(true);
        hlpdlg.setVisible(true);
    }

    protected void onFileOpen() {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName().toLowerCase();
                return name.endsWith(".xml") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "XML pose definition";
            }
        });
        fc.setCurrentDirectory(this.currentDir);
        if (fc.showOpenDialog(this) == 0) {
            File name = fc.getSelectedFile();
            this.loadImages(name);
        }
    }

    public void loadImages(File name) {
        this.currentDir = name.getParentFile();
        this.onNewDocument();
        this.setTitle("(Loading...)");
        if (this.progressBar != null) {
            this.progressBar.setVisible(false);
        }
        this.progressBar = new ProgressDlg(this, "Loading poses, please wait...");
        this.progressBar.setVisible(true);
        this.progressBar.setLocationRelativeTo(this);
        Thread thr = new Thread(new LoadImagesThread(name));
        thr.start();
    }

    private void onNewDocument() {
        this.setTitle(null);
        this.actions.attachView(null);
        if (this.curView != null) {
            this.workArea.remove(this.curView);
            this.curView.reset();
        }
        if (this.memoryInfo != null) {
            this.workArea.remove(this.memoryInfo);
            this.memoryInfo = null;
        }
        this.curView = null;
        System.gc();
    }

    private void showErrorDlg(Throwable ex, File name) {
        this.setTitle("(Error !)");
        String errText = ex.getLocalizedMessage();
        if (errText == null) {
            errText = ex.getMessage();
        }
        if (errText == null) {
            errText = ex.getClass().getName();
        }
        JOptionPane.showMessageDialog(this, "Unable to load '" + name.getAbsolutePath() + "'. Received error message: " + errText);
        ex.printStackTrace();
    }

    @Override
    public void handleExcption(Throwable e) {
        SwingUtilities.invokeLater(new HandleException(e));
    }

    public void handleExceptionLater(Throwable e) {
        if (this.errorShown) {
            return;
        }
        this.errorShown = true;
        this.actions.stopAnimation();
        String msg = e.getLocalizedMessage();
        if (msg == null) {
            msg = e.getClass().getName();
        }
        JOptionPane.showMessageDialog(this, "Received error message:" + msg);
        this.errorShown = false;
    }

    @Override
    public void setTitle(String title) {
        title = title == null || title.length() == 0 ? "Pose Viewer 1.0" : String.valueOf(title) + " - Pose Viewer 1.0";
        super.setTitle(title);
    }

    private class HandleException
    implements Runnable {
        private Throwable e;

        public HandleException(Throwable e) {
            this.e = e;
        }

        @Override
        public void run() {
            MainFrame.this.handleExceptionLater(this.e);
        }
    }

    private class LoadImagesThread
    implements Runnable {
        private File name;
        private PoseLoader loader;
        private Throwable ex;
        boolean retry;

        public LoadImagesThread(File name) {
            this.name = name;
            this.retry = false;
        }

        @Override
        public void run() {
            try {
                this.loader = new PoseLoader(this.name, MainFrame.this.progressBar);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (MainFrame.this.curView != null) {
                            MainFrame.this.workArea.remove(MainFrame.this.curView);
                        }
                        MainFrame.this.curView = new MyPoseView(new CurrentPose(LoadImagesThread.this.loader.getLoadedData()), MainFrame.this);
                        MainFrame.this.actions.attachView(MainFrame.this.curView);
                        MainFrame.this.workArea.add((Component)MainFrame.this.curView, "Center");
                        MainFrame.this.control.validate();
                        MainFrame.this.validate();
                        MainFrame.this.progressBar.setVisible(false);
                        MainFrame.this.setTitle(LoadImagesThread.this.loader.getTitle());
                    }
                });
            }
            catch (Throwable e) {
                this.ex = e;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.showErrorDlg(LoadImagesThread.this.ex, LoadImagesThread.this.name);
                        MainFrame.this.progressBar.setVisible(false);
                    }
                });
            }
        }
    }

    public class MyCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 464651348019L;

        public MyCheckBoxMenuItem(Action a) {
            super(a);
            CheckBoxActionPropertyListener.makeConnection(this, a);
        }
    }

    private class MyFileDrop
    implements FileDrop.Listener {
        private MyFileDrop() {
        }

        @Override
        public void filesDropped(File[] files) {
            if (files.length != 1) {
                JOptionPane.showMessageDialog(MainFrame.this, "Only one file can be dropped");
            } else {
                File f = files[0];
                if (f.getName().toLowerCase().endsWith(".xml")) {
                    MainFrame.this.loadImages(f);
                    MainFrame.this.currentDir = f.getParentFile();
                } else {
                    JOptionPane.showMessageDialog(MainFrame.this, "Unsupported file type. Only .XML file can be opened");
                }
            }
        }
    }

    private class MyPoseView
    extends PoseView {
        private static final long serialVersionUID = -3621672020449070472L;

        public MyPoseView(CurrentPose pose, ExceptionHandler exHandler) {
            super(pose, exHandler);
            this.setDisketteImg(ControlActions.loadIcon("loadwait.png"));
        }
    }
}

