/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import poseViewer.CachedImage;
import poseViewer.ImageCache;
import poseViewer.ImageLoadNotify;
import poseViewer.ProgressInfo;

public class PoseContainer {
    private CachedImage[] images = null;
    private int imagesInRotX = 0;
    private int imagesInRotY = 0;
    private float rotXStartAngle = 0.0f;
    private float rotXEndAngle = 0.0f;
    private float rotYStartAngle = 0.0f;
    private float rotYEndAngle = 0.0f;
    private boolean reverseX = false;
    private boolean reverseY = false;
    private ImageCache cache = null;

    public void loadImages(File path, String baseName, String ext, int poses, int rotXcnt, int rotYcnt, ProgressInfo progressInfo) throws Throwable {
        Throwable b;
        int totalCnt = poses * rotXcnt * rotYcnt;
        this.images = new CachedImage[totalCnt];
        int rotXtot = poses * rotXcnt;
        String maxStr = Integer.toString(rotXtot);
        int zeroesLen = maxStr.length();
        String zeroes = "";
        int i = 0;
        while (i < zeroesLen) {
            zeroes = String.valueOf(zeroes) + "0";
            ++i;
        }
        Runtime rt = Runtime.getRuntime();
        long availMemory = rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
        this.cache = new ImageCache(totalCnt, availMemory);
        int threads = Runtime.getRuntime().availableProcessors() + 1;
        Thread[] threadArr = new Thread[threads];
        CoreLoader[] loaderArr = new CoreLoader[threads];
        int i2 = 0;
        while (i2 < threads) {
            loaderArr[i2] = new CoreLoader(baseName, ext, this.cache, rotXtot, rotYcnt, i2, threads, zeroes, i2 == 0 ? progressInfo : null, path);
            threadArr[i2] = new Thread(loaderArr[i2]);
            threadArr[i2].start();
            ++i2;
        }
        i2 = 0;
        while (i2 < threads) {
            threadArr[i2].join();
            b = loaderArr[i2].getException();
            if (b != null && !b.getClass().equals(OutOfMemoryError.class)) {
                int j = i2 + 1;
                while (j < threads) {
                    loaderArr[j].stop();
                    threadArr[j].join();
                    ++j;
                }
                throw b;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < threads) {
            b = loaderArr[i2].getException();
            if (b != null) {
                loaderArr[i2].setProgress(progressInfo);
                loaderArr[i2].run();
                b = loaderArr[i2].getException();
                if (b != null) {
                    throw b;
                }
            }
            ++i2;
        }
        this.imagesInRotX = rotXcnt;
        this.imagesInRotY = rotYcnt;
    }

    public void loadTestImages(int poses, int rotXcnt, int rotYcnt) throws Throwable {
        int totalCnt = poses * rotXcnt * rotYcnt;
        this.images = new CachedImage[totalCnt];
        int rotXtot = poses * rotXcnt;
        this.cache = new ImageCache(totalCnt, Runtime.getRuntime().totalMemory());
        int i = 0;
        while (i < rotXtot) {
            int j = 0;
            while (j < rotYcnt) {
                int idx = i * rotYcnt + j;
                this.images[idx] = new DebugImage(this.cache, i / rotXcnt, i % rotXcnt, j);
                ++j;
            }
            ++i;
        }
        this.imagesInRotX = rotXcnt;
        this.imagesInRotY = rotYcnt;
        this.setXAngles(0.0f, 0.0f);
        this.setYAngles(-60.0f, 60.0f);
    }

    public Image getImage(int pose, int rotX, int rotY, ImageLoadNotify ntf) throws Throwable {
        int idx = (pose * this.imagesInRotX + rotX) * this.imagesInRotY + rotY;
        return this.images[idx].getImage(ntf);
    }

    public int countPoses() {
        return this.images.length / (this.imagesInRotX * this.imagesInRotY);
    }

    public int countRotX() {
        return this.imagesInRotX;
    }

    public int countRotY() {
        return this.imagesInRotY;
    }

    public void setXAngles(float from, float to) {
        if (from > to || from == to && from < 0.0f) {
            this.reverseX = true;
            this.rotXStartAngle = to;
            this.rotXEndAngle = from;
        } else {
            this.reverseX = false;
            this.rotXStartAngle = from;
            this.rotXEndAngle = to;
        }
    }

    public void setYAngles(float from, float to) {
        if (from > to || from == to && from < 0.0f) {
            this.reverseY = true;
            this.rotYStartAngle = to;
            this.rotYEndAngle = from;
        } else {
            this.reverseY = false;
            this.rotYStartAngle = from;
            this.rotYEndAngle = to;
        }
    }

    public float getRotXStartAngle() {
        return this.rotXStartAngle;
    }

    public float getRotXEndAngle() {
        return this.rotXEndAngle;
    }

    public float getRotYStartAngle() {
        return this.rotYStartAngle;
    }

    public float getRotYEndAngle() {
        return this.rotYEndAngle;
    }

    public Image getImageA(int pose, float xrot, float yrot, ImageLoadNotify ntf) throws Throwable {
        float rely;
        float relx;
        if (this.rotXStartAngle == this.rotXEndAngle) {
            xrot -= this.rotXStartAngle;
            xrot = (float)((double)xrot - Math.floor(xrot / 360.0f) * 360.0);
            relx = xrot / 360.0f;
        } else {
            relx = (xrot - this.rotXStartAngle) / (this.rotXEndAngle - this.rotXStartAngle);
            if (relx < 0.0f) {
                relx = 0.0f;
            }
            if (relx >= 1.0f) {
                relx = 0.9999999f;
            }
        }
        if (this.rotYStartAngle == this.rotYEndAngle) {
            yrot -= this.rotXStartAngle;
            yrot = (float)((double)yrot - Math.floor(yrot / 360.0f) * 360.0);
            rely = yrot / 360.0f;
        } else {
            rely = (yrot - this.rotYStartAngle) / (this.rotYEndAngle - this.rotYStartAngle);
            if (rely < 0.0f) {
                rely = 0.0f;
            }
            if (rely >= 1.0f) {
                rely = 0.9999999f;
            }
        }
        int irotx = (int)Math.floor(relx * (float)this.imagesInRotX);
        int iroty = (int)Math.floor(rely * (float)this.imagesInRotY);
        if (this.reverseX) {
            irotx = this.imagesInRotX - 1 - irotx;
        }
        if (this.reverseY) {
            iroty = this.imagesInRotY - 1 - iroty;
        }
        return this.getImage(pose, irotx, iroty, ntf);
    }

    public boolean fullRotateX() {
        return this.rotXStartAngle == this.rotXEndAngle;
    }

    public boolean fullRotateY() {
        return this.rotYStartAngle == this.rotYEndAngle;
    }

    public float getAngleStepX() {
        float angleRange = 360.0f;
        if (this.rotXStartAngle != this.rotXEndAngle) {
            angleRange = this.rotXEndAngle - this.rotXStartAngle;
        }
        return this.imagesInRotX < 2 ? angleRange : angleRange / (float)(this.imagesInRotX - 1);
    }

    public float getAngleStepY() {
        float angleRange = 360.0f;
        if (this.rotYStartAngle != this.rotYEndAngle) {
            angleRange = this.rotYEndAngle - this.rotYStartAngle;
        }
        return this.imagesInRotY < 2 ? angleRange : angleRange / (float)(this.imagesInRotY - 1);
    }

    public boolean freeSomeMemory() {
        return this.cache.freeSomeMemory();
    }

    public ImageCache getCache() {
        return this.cache;
    }

    public long size() {
        return this.images.length;
    }

    private class CoreLoader
    implements Runnable {
        private Throwable exception = null;
        private String baseName;
        private String ext;
        private ImageCache cache;
        private int rotXtot;
        private int rotYcnt;
        private int loadPos;
        private int loadDiv;
        private String zeroes;
        private ProgressInfo progressInfo;
        private File path;
        private boolean stopNow = false;

        @Override
        public void run() {
            this.exception = null;
            try {
                int i = 0;
                while (i < this.rotXtot) {
                    int j = 0;
                    while (j < this.rotYcnt) {
                        if (this.stopNow) {
                            return;
                        }
                        int idx = i * this.rotYcnt + j;
                        String indexStr = Integer.toString(i + 1);
                        if (indexStr.length() < this.zeroes.length()) {
                            indexStr = String.valueOf(this.zeroes.substring(indexStr.length())) + indexStr;
                        }
                        String name = String.valueOf(this.baseName) + indexStr + Character.toString((char)(j + 97)) + this.ext;
                        if (idx % this.loadDiv == this.loadPos && PoseContainer.this.images[idx] == null) {
                            File fname = new File(this.path, name);
                            if (!fname.canRead()) {
                                throw new IOException("Cannot read file: " + fname.getName());
                            }
                            ((PoseContainer)PoseContainer.this).images[idx] = new CachedImage(this.cache, fname);
                            if (this.progressInfo != null) {
                                this.progressInfo.setProgressInfo(i, this.rotXtot);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.exception = e;
            }
        }

        public CoreLoader(String baseName, String ext, ImageCache cache, int rotXtot, int rotYcnt, int loadPos, int loadDiv, String zeroes, ProgressInfo progressInfo, File path) {
            this.baseName = baseName;
            this.ext = ext;
            this.cache = cache;
            this.rotXtot = rotXtot;
            this.rotYcnt = rotYcnt;
            this.loadPos = loadPos;
            this.loadDiv = loadDiv;
            this.zeroes = zeroes;
            this.progressInfo = progressInfo;
            this.path = path;
        }

        void setProgress(ProgressInfo dlg) {
            this.progressInfo = dlg;
        }

        public Throwable getException() {
            return this.exception;
        }

        public void stop() {
            this.stopNow = true;
        }

        public ImageCache getCache() {
            return this.cache;
        }
    }

    class DebugImage
    extends CachedImage {
        private int angleX;
        private int angleY;
        private int pose;

        public DebugImage(ImageCache cache, int pose, int angleX, int angleY) throws Throwable {
            super(cache, null);
            this.angleX = angleX;
            this.angleY = angleY;
            this.pose = pose;
        }

        @Override
        Image createImage(ImageLoadNotify observer) throws Throwable {
            BufferedImage img = new BufferedImage(300, 400, 5);
            Graphics2D g = img.createGraphics();
            g.setColor(new Color(200, 180, 160));
            g.fillRect(0, 0, 300, 400);
            g.setColor(new Color(0, 0, 0));
            g.drawString("Pose:   " + Integer.toString(this.pose) + ", AngleX: " + Integer.toString(this.angleX) + ", AngleY: " + Integer.toString(this.angleY), 20, 20);
            return img;
        }
    }
}

