/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import poseViewer.CachedImage;
import poseViewer.ImageCache;
import poseViewer.ImageLoadNotify;
import poseViewer.ProgressInfo;

public class PoseContainer2 {
    List poses = null;
    List imageFileNames = null;
    private ImageCache cache;
    private CachedImage[] images = null;
    static /* synthetic */ Class class$0;

    void addPose(int rows, int cols, List imageFileNames, PoseFlags flags) {
        if (this.imageFileNames == null) {
            this.imageFileNames = new ArrayList();
        }
        if (this.poses == null) {
            this.poses = new ArrayList();
        }
        this.poses.add(new PoseInfo(flags, this.imageFileNames.size(), imageFileNames.size(), rows, cols));
        this.imageFileNames.addAll(imageFileNames);
    }

    public void loadImages(ProgressInfo progressInfo) throws Throwable {
        Runtime rt = Runtime.getRuntime();
        long availMemory = rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
        int processors = rt.availableProcessors();
        int threads = processors + 2;
        int totalCnt = this.imageFileNames.size();
        this.images = new CachedImage[totalCnt];
        LoadImageThread[] activeThreads = new LoadImageThread[threads];
        int i = 0;
        while (i < threads) {
            activeThreads[i] = new LoadImageThread();
            ++i;
        }
        this.cache = new ImageCache(totalCnt, availMemory);
        int idx = 0;
        Iterator iter = this.imageFileNames.iterator();
        int thrid = 0;
        int running = threads;
        int oomerr = 0;
        while (iter.hasNext() || running > 0) {
            LoadImageThread t = activeThreads[thrid];
            thrid = (thrid + 1) % threads;
            t.join();
            if (t.isExceptional()) {
                Throwable b = t.getException();
                Class<?> clazz = b.getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.OutOfMemoryError");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2) && oomerr < 8) {
                    t.restart();
                    ++oomerr;
                    continue;
                }
                throw b;
            }
            --running;
            oomerr = 0;
            if (iter.hasNext()) {
                File f = (File)iter.next();
                t.start(idx++, f, this.cache);
                ++running;
            }
            progressInfo.setProgressInfo(idx, totalCnt);
        }
    }

    public Image getImage(int pose, int rotX, int rotY, ImageLoadNotify ntf) throws Throwable {
        PoseInfo posedef = (PoseInfo)this.poses.get(pose);
        int index = posedef.startImage + posedef.cols * rotY + rotX;
        return this.images[index].getImage(ntf);
    }

    public int countPoses() {
        return this.poses.size();
    }

    public int countRotX(int pose) {
        PoseInfo posedef = (PoseInfo)this.poses.get(pose);
        return posedef.cols;
    }

    public int countRotY(int pose) {
        PoseInfo posedef = (PoseInfo)this.poses.get(pose);
        return posedef.rows;
    }

    public void setXAngles(float from, float to) {
    }

    public void setYAngles(float from, float to) {
    }

    public float getRotYStartAngle() {
        return -90.0f;
    }

    public float getRotYEndAngle() {
        return 90.0f;
    }

    public float getRotXStartAngle() {
        return 0.0f;
    }

    public float getRotXEndAngle() {
        return 0.0f;
    }

    public Image getImageA(int pose, float xrot, float yrot, ImageLoadNotify ntf) throws Throwable {
        float rely;
        float relx;
        PoseInfo pinfo = (PoseInfo)this.poses.get(pose);
        if (pinfo.fullRotCol) {
            xrot -= this.getRotXStartAngle();
            xrot = (float)((double)xrot - Math.floor(xrot / 360.0f) * 360.0);
            relx = xrot / 360.0f;
        } else {
            relx = (xrot - this.getRotXStartAngle()) / (this.getRotXEndAngle() - this.getRotXStartAngle());
            if (relx < 0.0f) {
                relx = 0.0f;
            }
            if (relx >= 1.0f) {
                relx = 0.9999999f;
            }
        }
        if (pinfo.fullRotRow) {
            yrot -= this.getRotXStartAngle();
            yrot = (float)((double)yrot - Math.floor(yrot / 360.0f) * 360.0);
            rely = yrot / 360.0f;
        } else {
            rely = (yrot - this.getRotYStartAngle()) / (this.getRotYEndAngle() - this.getRotYStartAngle());
            if (rely < 0.0f) {
                rely = 0.0f;
            }
            if (rely >= 1.0f) {
                rely = 0.9999999f;
            }
        }
        int irotx = (int)Math.floor(relx * (float)pinfo.cols);
        int iroty = (int)Math.floor(rely * (float)pinfo.rows);
        if (pinfo.reversedCol) {
            irotx = pinfo.cols - 1 - irotx;
        }
        if (pinfo.reversedRow) {
            iroty = pinfo.rows - 1 - iroty;
        }
        return this.getImage(pose, irotx, iroty, ntf);
    }

    public boolean fullRotateX(int pose) {
        PoseInfo pinfo = (PoseInfo)this.poses.get(pose);
        return pinfo.fullRotCol;
    }

    public boolean fullRotateY(int pose) {
        PoseInfo pinfo = (PoseInfo)this.poses.get(pose);
        return pinfo.fullRotRow;
    }

    public float getAngleStepX(int pose) {
        float angleRange = 360.0f;
        if (!this.fullRotateX(pose)) {
            angleRange = this.getRotXEndAngle() - this.getRotXStartAngle();
        }
        return this.countRotX(pose) < 2 ? angleRange : angleRange / (float)this.countRotX(pose);
    }

    public float getAngleStepY(int pose) {
        float angleRange = 360.0f;
        if (!this.fullRotateY(pose)) {
            angleRange = this.getRotYEndAngle() - this.getRotYStartAngle();
        }
        return this.countRotY(pose) < 2 ? angleRange : angleRange / (float)this.countRotY(pose);
    }

    public boolean freeSomeMemory() {
        return this.cache.freeSomeMemory();
    }

    public ImageCache getCache() {
        return this.cache;
    }

    public long size() {
        return 0L;
    }

    public class LoadImageThread
    implements Runnable {
        private int index;
        private Throwable exception;
        private File file;
        private ImageCache cache;
        Thread t = null;

        public void start(int index, File f, ImageCache c) {
            this.t = new Thread(this);
            this.index = index;
            this.exception = null;
            this.file = f;
            this.cache = c;
            this.t.start();
        }

        public void restart() {
            this.exception = null;
            this.t = new Thread(this);
            this.t.start();
        }

        public void join() throws InterruptedException {
            if (this.t != null) {
                this.t.join();
            }
        }

        public void run() {
            try {
                ((PoseContainer2)PoseContainer2.this).images[this.index] = new CachedImage(this.cache, this.file);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public boolean isExceptional() {
            return this.exception != null;
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    public static class PoseFlags {
        boolean reversedCol;
        boolean reversedRow;
        boolean fullRotCol;
        boolean fullRotRow;

        public PoseFlags(boolean reversedCol, boolean reversedRow, boolean fullRotCol, boolean fullRotRow) {
            this.reversedCol = reversedCol;
            this.reversedRow = reversedRow;
            this.fullRotCol = fullRotCol;
            this.fullRotRow = fullRotRow;
        }

        public PoseFlags(PoseFlags flags) {
            this(flags.reversedCol, flags.reversedRow, flags.fullRotCol, flags.fullRotRow);
        }
    }

    static class PoseInfo
    extends PoseFlags {
        public int startImage;
        public int countImages;
        public int rows;
        public int cols;

        public PoseInfo(PoseFlags flags, int startImage, int countImages, int rows, int cols) {
            super(flags);
            this.startImage = startImage;
            this.countImages = countImages;
            this.rows = rows;
            this.cols = cols;
        }
    }
}

