/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.management.modelmbean.XMLParseException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import poseViewer.PoseContainer2;
import poseViewer.ProgressInfo;

public class PoseLoader {
    private PoseContainer2 loadedData;
    private String title;
    private File fname;
    private ProgressInfo progressInfo;

    PoseLoader(File fname, ProgressInfo progressInfo) throws Throwable {
        this.fname = fname;
        this.progressInfo = progressInfo;
        this.loadFile();
    }

    private void loadFile() throws Throwable {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(this.fname);
        NodeList root = doc.getElementsByTagName("imageSet");
        if (root.getLength() == 1) {
            this.loadOldFormat(this.fname, root);
        } else {
            root = doc.getElementsByTagName("poses");
            if (root.getLength() == 1) {
                this.loadNewFormat(this.fname, root);
            } else {
                throw new XMLParseException("Unknown format of metafile: " + this.fname.getAbsolutePath());
            }
        }
    }

    private void loadNewFormat(File fname2, NodeList root) throws Throwable {
        Element poses = (Element)root.item(0);
        this.loadedData = new PoseContainer2();
        NodeList title = poses.getElementsByTagName("title");
        if (title.getLength() != 0) {
            this.title = ((Element)title.item(0)).getChildNodes().item(0).getNodeValue();
        }
        NodeList poseList = poses.getElementsByTagName("pose");
        int i = 0;
        int cnt = poseList.getLength();
        while (i < cnt) {
            NodeList angleNL;
            int rangeFrom = 0;
            int rangeTo = 0;
            Element poseEl = (Element)poseList.item(i);
            NodeList rangeList = poseEl.getElementsByTagName("range");
            boolean reversed = false;
            if (rangeList.getLength() == 1) {
                Element rangeEl = (Element)rangeList.item(0);
                rangeFrom = Integer.parseInt(rangeEl.getAttribute("from"));
                rangeTo = Integer.parseInt(rangeEl.getAttribute("to"));
                if (rangeEl.hasAttribute("reversed") && Integer.parseInt(rangeEl.getAttribute("reversed")) == 1) {
                    reversed = true;
                }
            } else {
                throw new Error("<range> must be once pere pose, and is also mandatory.");
            }
            ArrayList fileList = new ArrayList();
            NodeList angleList = poseEl.getElementsByTagName("angles");
            float angleMin = -90.0f;
            float angleMax = 90.0f;
            if (angleList.getLength() == 1) {
                Element angles = (Element)angleList.item(0);
                angleNL = angles.getElementsByTagName("angle");
                if (angles.hasAttribute("min")) {
                    angleMin = Float.parseFloat(angles.getAttribute("min"));
                }
                if (angles.hasAttribute("max")) {
                    angleMax = Float.parseFloat(angles.getAttribute("max"));
                }
                int i2 = 0;
                int cnt2 = angleNL.getLength();
                while (i2 < cnt2) {
                    Element angle = (Element)angleNL.item(i2);
                    String fname = angle.getAttribute("filename");
                    this.createFileList(fileList, fname, rangeFrom, rangeTo, fname2.getParent());
                    ++i2;
                }
            } else {
                throw new Error("<angles> must be once pere pose, and is also mandatory.");
            }
            this.loadedData.addPose(angleNL.getLength(), rangeTo - rangeFrom + 1, fileList, new PoseContainer2.PoseFlags(reversed, angleMin == angleMax ? angleMin < 0.0f : angleMin > angleMax, true, angleMin == angleMax));
            ++i;
        }
        this.loadedData.loadImages(this.progressInfo);
    }

    private void createFileList(List fileList, String fname, int rangeFrom, int rangeTo, String basePath) throws Error {
        int start = fname.indexOf(35);
        if (start == -1) {
            throw new Error("Character '#' missing in filename: " + fname + ". This character is used instead the frame number.");
        }
        int end = start;
        while (end < fname.length() && fname.charAt(end) == '#') {
            ++end;
        }
        int zeroes = end - start;
        int i = rangeFrom;
        while (i <= rangeTo) {
            StringBuilder bld = new StringBuilder();
            bld.append(fname);
            bld.delete(start, end);
            int len = bld.length();
            bld.insert(start, i);
            int len2 = bld.length();
            int zr = zeroes - (len2 - len);
            int z = 0;
            while (z < zr) {
                bld.insert(start, '0');
                ++z;
            }
            fileList.add(new File(basePath, bld.toString()));
            ++i;
        }
    }

    private void loadOldFormat(File fname2, NodeList root) throws Throwable {
        Element imageSet = (Element)root.item(0);
        String prefix = imageSet.getAttribute("prefix");
        String ext = imageSet.getAttribute("ext");
        NodeList title = imageSet.getElementsByTagName("title");
        if (title.getLength() != 0) {
            this.title = ((Element)title.item(0)).getChildNodes().item(0).getNodeValue();
        }
        NodeList images = imageSet.getElementsByTagName("images");
        Element elem = (Element)images.item(0);
        int rotY = Integer.parseInt(elem.getAttribute("rotX"));
        int rotX = Integer.parseInt(elem.getAttribute("rotY"));
        int poses = Integer.parseInt(elem.getAttribute("poses"));
        NodeList angles = imageSet.getElementsByTagName("angles");
        elem = (Element)angles.item(0);
        float rotYmin = Float.parseFloat(elem.getAttribute("rotXmin"));
        float rotXmin = Float.parseFloat(elem.getAttribute("rotYmin"));
        float rotYmax = Float.parseFloat(elem.getAttribute("rotXmax"));
        float rotXmax = Float.parseFloat(elem.getAttribute("rotYmax"));
        this.loadedData = new PoseContainer2();
        File basePath = this.fname.getParentFile();
        int rotXtot = poses * rotX;
        String maxStr = Integer.toString(rotXtot);
        int zeroesLen = maxStr.length();
        String zeroes = "";
        int i = 0;
        while (i < zeroesLen) {
            zeroes = String.valueOf(zeroes) + "0";
            ++i;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        int imgcnt = 1;
        int i2 = 0;
        while (i2 < poses) {
            fileList.clear();
            int j = 0;
            while (j < rotY) {
                int imgp = imgcnt;
                int k = 0;
                while (k < rotX) {
                    String idxstr = Integer.toString(imgp++);
                    StringBuilder bld = new StringBuilder();
                    bld.append(prefix);
                    bld.append(zeroes.substring(0, zeroes.length() - idxstr.length()));
                    bld.append(idxstr);
                    bld.append((char)(97 + j));
                    bld.append(ext);
                    fileList.add(new File(basePath, bld.toString()));
                    ++k;
                }
                ++j;
            }
            imgcnt += rotX;
            this.loadedData.addPose(rotY, rotX, fileList, new PoseContainer2.PoseFlags(rotXmin == rotXmax ? rotXmin < 0.0f : rotXmin > rotXmax, rotYmin == rotYmax ? rotYmin < 0.0f : rotYmin > rotYmax, rotXmin == rotXmax, rotYmin == rotYmax));
            ++i2;
        }
        this.loadedData.loadImages(this.progressInfo);
    }

    public PoseContainer2 getLoadedData() {
        return this.loadedData;
    }

    public String getTitle() {
        return this.title;
    }

    public File getFname() {
        return this.fname;
    }

    public static class Error
    extends Exception {
        private static final long serialVersionUID = 2819613538159263265L;

        public Error(String desc) {
            super(desc);
        }
    }
}

