/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import poseViewer.CurrentPose;
import poseViewer.ExceptionHandler;
import poseViewer.ImageLoadNotify;
import poseViewer.ImagePanZoom;

public class PoseView
extends JComponent
implements Printable {
    private static final long serialVersionUID = -4625231879268948077L;
    public static final int THUMB_TYPE_CURZOOM = 0;
    public static final int THUMB_TYPE_FITSCREEN = 1;
    public static final int THUMB_TYPE_1TO1 = 2;
    private CurrentPose poseControl;
    private ImagePanZoom panZoom = new ImagePanZoom();
    private Image lastImage = null;
    private ExceptionHandler exHandler = null;
    private boolean drawDiskette = false;
    private Icon disketteImg = null;
    private boolean noErrorShow = false;
    private boolean thumbOnly = false;
    private int thumbType = 0;

    public PoseView(CurrentPose pose, ExceptionHandler exHandler) {
        this.poseControl = pose;
        this.exHandler = exHandler;
        this.addMouseMotionListener(new MouseMotionListener(){
            private Point lastPoint = null;

            @Override
            public void mouseDragged(MouseEvent e) {
                PoseView.this.onMouseDragged(this.getRelativeMove(e.getPoint()), e);
            }

            private Point getRelativeMove(Point point) {
                if (this.lastPoint == null) {
                    this.lastPoint = point;
                    return new Point(0, 0);
                }
                Point res = new Point(point.x - this.lastPoint.x, point.y - this.lastPoint.y);
                this.lastPoint = point;
                return res;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                PoseView.this.onMouseMoved(this.getRelativeMove(e.getPoint()), e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                PoseView.this.onMouseWheel(e);
            }
        });
    }

    protected void onMouseWheel(MouseWheelEvent e) {
        if (this.thumbOnly && this.thumbType != 0) {
            return;
        }
        int rel = e.getWheelRotation();
        this.panZoom.setZoom(this.panZoom.getZoom() + (float)rel * 0.1f);
        this.repaint();
    }

    protected void onMouseDragged(Point relativeMove, MouseEvent e) {
        if ((e.getModifiersEx() & 0x1000) != 0) {
            if (this.thumbOnly && this.thumbType != 0) {
                return;
            }
            this.panStep(relativeMove);
        } else if ((e.getModifiersEx() & 0x400) != 0) {
            this.poseControl.setCurAngX(this.poseControl.getCurAngX() + (float)relativeMove.x * 0.5f);
            this.poseControl.setCurAngY(this.poseControl.getCurAngY() - (float)relativeMove.y * 0.5f);
            this.fastRepaint();
        }
    }

    protected void onMouseMoved(Point relativeMove, MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Dimension orgTrg = this.getSize();
        Notify ntf = new Notify();
        Dimension orgSrc = this.poseControl.getImageSize(ntf);
        Image imgToDraw = null;
        try {
            imgToDraw = this.poseControl.getImage(ntf);
        }
        catch (Throwable e) {
            this.exHandler.handleExcption(e);
            return;
        }
        this.lastImage = imgToDraw;
        ImagePanZoom.TwoRects rcs = this.panZoom.calcRects(orgSrc, orgTrg);
        while ((rcs.target.width < 5 || rcs.target.height < 5) && orgTrg.width > 5 && orgTrg.height > 5) {
            this.panZoom.setZoom((float)((double)this.panZoom.getZoom() + 0.1));
            rcs = this.panZoom.calcRects(orgSrc, this.getSize());
        }
        while ((rcs.source.width < 5 || rcs.source.height < 5) && orgSrc.width > 5 && orgSrc.height > 5) {
            this.panZoom.setZoom((float)((double)this.panZoom.getZoom() - 0.1));
            rcs = this.panZoom.calcRects(orgSrc, this.getSize());
        }
        if (this.thumbOnly) {
            ImagePanZoom.TwoRects suggRect = null;
            ImagePanZoom privPanZoom = null;
            switch (this.thumbType) {
                case 0: {
                    privPanZoom = this.panZoom;
                    break;
                }
                case 1: {
                    privPanZoom = new ImagePanZoom();
                    break;
                }
                case 2: {
                    privPanZoom = new ImagePanZoom();
                    privPanZoom.fitToView(orgSrc, orgSrc);
                    privPanZoom.setCenterX(this.panZoom.getCenterX());
                    privPanZoom.setCenterY(this.panZoom.getCenterY());
                }
            }
            suggRect = privPanZoom.calcRects(orgSrc, orgTrg);
            if (suggRect.target.width <= rcs.target.width && suggRect.source.width >= rcs.source.width || suggRect.target.height <= rcs.target.height && suggRect.source.height >= rcs.source.height) {
                rcs = suggRect;
            }
        }
        g.drawImage(imgToDraw, rcs.target.x, rcs.target.y, rcs.target.x + rcs.target.width, rcs.target.y + rcs.target.height, rcs.source.x, rcs.source.y, rcs.source.x + rcs.source.width, rcs.source.y + rcs.source.height, null);
        if (this.drawDiskette && this.disketteImg != null) {
            this.disketteImg.paintIcon(this, g, 0, 0);
        }
    }

    public ImagePanZoom getPanZoom() {
        return this.panZoom;
    }

    public void setPanZoom(ImagePanZoom pz) {
        this.panZoom = pz;
        this.repaint();
    }

    public void fastRepaint() {
        try {
            Image curImg = this.poseControl.getImage(new Notify());
            if (curImg != this.lastImage) {
                this.repaint();
            }
        }
        catch (Throwable e) {
            this.exHandler.handleExcption(e);
            return;
        }
    }

    public void fitToView() {
        this.panZoom.fitToView(this.poseControl.getImageSize(new Notify()), this.getSize());
        this.repaint();
    }

    public CurrentPose getCurrentPose() {
        return this.poseControl;
    }

    public void zoomStep(int i) {
        this.panZoom.setZoom(this.panZoom.getZoom() + (float)i * 0.1f);
        this.repaint();
    }

    public void panStep(Point relativeMove) {
        Point2D.Float xr = this.panZoom.mapMove(relativeMove, this.poseControl.getImageSize(new Notify()), this.getSize());
        xr.x = this.panZoom.getCenterX() - xr.x;
        xr.y = this.panZoom.getCenterY() - xr.y;
        if (xr.x < 0.0f) {
            xr.x = 0.0f;
        }
        if (xr.y < 0.0f) {
            xr.y = 0.0f;
        }
        if (xr.x > 1.0f) {
            xr.x = 1.0f;
        }
        if (xr.y > 1.0f) {
            xr.y = 1.0f;
        }
        this.panZoom.setCenterX(xr.x);
        this.panZoom.setCenterY(xr.y);
        this.repaint();
    }

    public void panStep(int i, int j) {
        this.panStep(new Point(i, j));
    }

    public Icon getDisketteImg() {
        return this.disketteImg;
    }

    public void setDisketteImg(Icon disketteImg) {
        this.disketteImg = disketteImg;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g = (Graphics2D)graphics;
        Dimension orgSrc = this.poseControl.getImageSize(null);
        Dimension orgTrg = new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        Image imgToDraw = null;
        try {
            imgToDraw = this.poseControl.getImage(null);
        }
        catch (Throwable e) {
            this.exHandler.handleExcption(e);
            PrinterException x = new PrinterException("Print failed");
            x.initCause(e);
            throw x;
        }
        this.lastImage = imgToDraw;
        ImagePanZoom.TwoRects rcs = new ImagePanZoom().calcRects(orgSrc, orgTrg);
        g.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g.drawImage(imgToDraw, rcs.target.x, rcs.target.y, rcs.target.x + rcs.target.width, rcs.target.y + rcs.target.height, rcs.source.x, rcs.source.y, rcs.source.x + rcs.source.width, rcs.source.y + rcs.source.height, null);
        return 0;
    }

    public void toClipboard() {
        Clipboard cp = Toolkit.getDefaultToolkit().getSystemClipboard();
        Image imgToDraw = null;
        try {
            imgToDraw = this.poseControl.getImage(null);
            cp.setContents(new ImageSelection(imgToDraw), new ClipOwner());
        }
        catch (OutOfMemoryError e) {
            if (this.poseControl.getPoses().freeSomeMemory()) {
                this.toClipboard();
            } else {
                this.exHandler.handleExcption(e);
            }
        }
        catch (Throwable e) {
            this.exHandler.handleExcption(e);
        }
    }

    public void reset() {
        this.poseControl = null;
    }

    public boolean isThumbOnly() {
        return this.thumbOnly;
    }

    public void setThumbOnly(boolean thumbOnly) {
        this.thumbOnly = thumbOnly;
    }

    public int getThumbType() {
        return this.thumbType;
    }

    public void setThumbType(int thumbType) {
        this.thumbType = thumbType;
    }

    public void zoom1to1() {
        Dimension viewSz = this.getSize();
        Dimension imgSz = this.poseControl.getImageSize(null);
        int ref = ImagePanZoom.getDominantImgSize(imgSz, viewSz);
        this.panZoom.setScale(1.0f, ref);
        this.repaint();
    }

    public static class ClipOwner
    implements ClipboardOwner {
        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    public static class ImageSelection
    implements Transferable {
        private Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }

    public class Notify
    implements ImageLoadNotify {
        @Override
        public void loadComplete(Image e) {
            PoseView.this.drawDiskette = false;
            SwingUtilities.invokeLater(new LoadComplete(e));
        }

        @Override
        public void loadError(Throwable e) {
            PoseView.this.drawDiskette = false;
            SwingUtilities.invokeLater(new LoadError(e));
        }

        @Override
        public void loadStarted() {
            PoseView.this.drawDiskette = true;
        }

        @Override
        public boolean getThumbOnly() {
            return PoseView.this.thumbOnly;
        }

        private class LoadComplete
        implements Runnable {
            @Override
            public void run() {
                PoseView.this.repaint();
            }

            public LoadComplete(Image img) {
            }
        }

        private class LoadError
        implements Runnable {
            private Throwable e;

            public LoadError(Throwable e) {
                this.e = e;
            }

            @Override
            public void run() {
                if (PoseView.this.noErrorShow) {
                    return;
                }
                PoseView.this.noErrorShow = true;
                String msg = this.e.getLocalizedMessage();
                if (msg == null) {
                    msg = this.e.getClass().getName();
                }
                JOptionPane.showMessageDialog(PoseView.this, "Unable to load image: " + msg);
                PoseView.this.noErrorShow = false;
            }
        }
    }
}

