/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import poseViewer.ProgressInfo;

public class ProgressDlg
extends JDialog
implements ProgressInfo {
    private static final long serialVersionUID = -6308350590089405390L;
    private JProgressBar progress;
    private boolean canceled;

    public ProgressDlg(JFrame owner, String title) {
        super((Frame)owner, title);
        Container pane = this.getContentPane();
        pane.setLayout(new GridLayout(0, 1));
        this.progress = new JProgressBar();
        pane.add(this.progress);
        Container cancelArea = new Container();
        pane.add(cancelArea);
        cancelArea.setLayout(new FlowLayout(1));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDlg.this.canceled = true;
            }
        });
        cancelArea.add(cancelButton);
        this.setSize(new Dimension(300, 100));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgressDlg.this.canceled = true;
            }
        });
        this.reset();
    }

    public void reset() {
        this.canceled = false;
    }

    @Override
    public void setProgressInfo(int cur, int max) throws CanceledException {
        SwingUtilities.invokeLater(new SetProgressRunnable(cur, max));
        if (this.canceled) {
            this.canceled = false;
            throw new CanceledException();
        }
    }

    public class CanceledException
    extends Exception {
        private static final long serialVersionUID = 9044848240894604122L;

        public CanceledException() {
            super("Operation has been canceled");
        }
    }

    private class SetProgressRunnable
    implements Runnable {
        private int cur;
        private int max;

        @Override
        public void run() {
            ProgressDlg.this.progress.setMaximum(this.max);
            ProgressDlg.this.progress.setValue(this.cur);
        }

        public SetProgressRunnable(int cur, int max) {
            this.cur = cur;
            this.max = max;
        }
    }
}

