/*
 * Decompiled with CFR 0.152.
 */
package poseViewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class URLLabel
extends JLabel {
    private String url;
    private Frame parentFrame;
    private static final long serialVersionUID = 165463564790846L;

    public URLLabel(String string, String string2, boolean first, Frame parentFrame) {
        super("<html><u>" + string + "</u></html>");
        this.url = string2;
        EmptyBorder b = new EmptyBorder(0, 5, 0, 5);
        if (first) {
            this.setBorder(b);
        } else {
            this.setBorder(new CompoundBorder(new Border(){

                @Override
                public Insets getBorderInsets(Component c) {
                    return new Insets(0, 0, 0, 0);
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    g.setColor(Color.WHITE);
                    g.drawLine(0, 0, 0, height);
                }
            }, b));
        }
        this.setCursor(new Cursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                URLLabel.this.onClickUrl();
            }
        });
        this.parentFrame = parentFrame;
        this.setForeground(new Color(255, 220, 0));
    }

    public void onClickUrl() {
        URLLabel.showInBrowser(this.url, this.parentFrame);
    }

    public static boolean showInBrowser(String url, Frame frame) {
        if (frame != null) {
            frame.setExtendedState(1);
        }
        String os = System.getProperty("os.name").toLowerCase();
        Runtime rt = Runtime.getRuntime();
        try {
            if (os.indexOf("win") >= 0) {
                String[] cmd = new String[]{"cmd.exe", "/C", "start", url};
                rt.exec(cmd);
            } else if (os.indexOf("mac") >= 0) {
                rt.exec("open " + url);
            } else {
                String[] browsers = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
                StringBuffer cmd = new StringBuffer();
                int i = 0;
                while (i < browsers.length) {
                    cmd.append(String.valueOf(i == 0 ? "" : " || ") + browsers[i] + " \"" + url + "\" ");
                    ++i;
                }
                rt.exec(new String[]{"sh", "-c", cmd.toString()});
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(frame, "\n\n The system failed to invoke your default web browser while attempting to access: \n\n " + url + "\n\n", "Browser Error", 2);
            return false;
        }
        return true;
    }
}

